<?php

namespace Schema31\UtilityBundle\Service\Ricerca;

use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\OptionsResolver\OptionsResolver;

/**
 * Servizio che cerca di standardizare la ricerca nel sistema
 * Il servizio ha un metodo ricerca che genera la form di ricerca,effettua la query e ritorna i risultati
 */
class Get extends AbstractMethod {
    public function __construct(
            $numeroElementi,
            EntityManagerInterface $entityManager,
            PaginatorInterface $paginator,
            RequestStack $requestStack,
            FormFactoryInterface $formFactory
        ) {
        $this->entityManager = $entityManager;
        $this->paginator = $paginator;
        $this->request = $requestStack->getCurrentRequest();
        $this->formFactory = $formFactory;
        $this->numeroDefaultElementi = $numeroElementi;
    }

    public function pulisci(array $attributiRicerca): void {
    }

    public function ricerca(array $options = []): array {
        $parameters = $this->resolveOptions($options);
        $this->data = $parameters['data'];

        $this->limit = $this->getNumeroElementiPerPagina($parameters['elements_per_page']);

        $formRicerca = $this->formFactory
            ->createBuilder($parameters['form_type'], $this->data, $parameters['form_options'])
            ->setMethod('GET')
            ->getForm();

        $this->addChoiceElementsPerPage($formRicerca, $parameters);

        $formRicerca->handleRequest($this->request);
        $this->aggiornaElementiDaVisualizzare($formRicerca, $parameters['elements_per_page']);
        $filtroAttivo = false;
        if ($formRicerca->isSubmitted()) {
            $filtroAttivo = true;
        }

        $repository = $this->entityManager->getRepository($parameters['repository']);
        $paginationObject = \call_user_func([$repository, $parameters['repository_method']], $this->data);
        $nomeParametroPagina = $parameters['page_index'];
        $numeroPaginaRicerca = $this->request->get($nomeParametroPagina, 1);
        $pagination = $this->paginate($paginationObject, $numeroPaginaRicerca);

        return [
            "risultato" => $pagination,
            "form_ricerca" => $formRicerca->createView(),
            "filtro_attivo" => $filtroAttivo,
            'form' => $formRicerca,
        ];
    }

    private function resolveOptions(array $options): array {
        $resolver = new OptionsResolver();
        $resolver->setDefaults([
            'data' => null,
            'choice_elements_per_page' => [
                '5' => 5,
                '10' => 10,
                '25' => 25,
                '50' => 50,
                '75' => 75,
                '100' => 100,
            ],
            'elements_per_page' => $this->numeroDefaultElementi,
            'page_index' => 'page',
            'show_elements_number' => false,
            'form_options' => []
        ]);
        $resolver->setRequired('form_type');
        $resolver->setRequired('repository');
        $resolver->setRequired('repository_method');

        $resolver->setAllowedTypes('form_type', 'string');
        $resolver->setAllowedTypes('form_options', 'array');
        $resolver->setAllowedTypes('repository', 'string');
        $resolver->setAllowedTypes('repository_method', 'string');
        $resolver->setAllowedTypes('page_index', 'string');
        $resolver->setAllowedTypes('choice_elements_per_page', 'int[]');
        $resolver->setAllowedTypes('elements_per_page', ['int', 'callable', 'null']);
        $resolver->setAllowedTypes('show_elements_number', 'bool');

        $parameters = $resolver->resolve($options);

        return $parameters;
    }

    private function getNumeroElementiPerPagina($opzione) {
        $opzioneNormalizzata = \is_callable($opzione) ? null : $opzione;
        $numElementi = $this->limit ??
                        $opzioneNormalizzata ??
                        $this->numeroDefaultElementi ??
                        0;

        return $numElementi;
    }
}
