<?php

namespace Tests\Repository;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Mapping\ClassMetadata;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Schema31\UtilityBundle\Repository\LazyQueryBuilder;
use Schema31\UtilityBundle\Repository\LazyRepository;

class LazyRepostoryTest extends TestCase {
    public function testCreateLazyQueryBuilder(): void {
        /** @var EntityManagerInterface|MockObject */
        $em = $this->createMock(EntityManagerInterface::class);
        /** @var ClassMetadata|MockObject */
        $classMetadata = $this->createMock(ClassMetadata::class);

        $repo = new LazyRepository($em, $classMetadata);
        $qb = $repo->createLazyQueryBuilder('x');

        $this->assertNotNull($qb);
        $this->assertInstanceOf(LazyQueryBuilder::class, $qb);
    }
}
