<?php

namespace Schema31\UtilityBundle\Service\Ricerca;

use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\QueryBuilder;
use Knp\Bundle\PaginatorBundle\Pagination\SlidingPagination;
use Knp\Component\Pager\PaginatorInterface;
use Schema31\UtilityBundle\Service\IRicerca;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\HttpFoundation\Request;

abstract class AbstractMethod implements IRicerca {
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @var PaginatorInterface
     */
    protected $paginator;

    /**
     * @var Request
     */
    protected $request;
    /**
     * @var FormFactoryInterface
     */
    protected $formFactory;

    /**
     * @var object|array|null
     */
    protected $data;

    /**
     * Numero default elementi per pagina
     * @var int
     */
    protected $numeroDefaultElementi;

    /**
     * Numero elementi selezionato dal form di ricerca
     * @var int|null
     */
    protected $limit;

    abstract public function pulisci(array $attributiRicerca): void;

    abstract public function ricerca(array $options = []): array;

    /**
     * @param array|AbstractQuery|QueryBuilder $paginationObject
     * @return SlidingPagination
     */
    protected function paginate($paginationObject, int $index) {
        if (\is_int($this->limit)) {
            return $this->paginator->paginate(
                $paginationObject,
                $index,
                $this->limit
            );
        }

        if ($paginationObject instanceof QueryBuilder) {
            $paginationObject = $paginationObject->getQuery();
        }
        if ($paginationObject instanceof AbstractQuery) {
            /** @var array */
            $paginationObject = $paginationObject->getResult();
        }

        return $this->paginator->paginate(
            $paginationObject,
            1,
            \count($paginationObject)
        );
    }

    protected function aggiornaElementiDaVisualizzare(FormInterface $form, $customNumberElements) {
        if (\is_callable($customNumberElements)) {
            $this->limit = $customNumberElements($form);
        }
        if ($form->has('numero_elementi')) {
            $this->limit = $form->get('numero_elementi')->getData();
        }
        if (\is_null($customNumberElements) || \is_null($this->limit)) {
            $this->limit = $this->numeroDefaultElementi;
        }
    }
    
    protected function addChoiceElementsPerPage(FormInterface $form, array $parameters) {
        if ($parameters['show_elements_number']) {
            $listaElementiPerPagina = $parameters['choice_elements_per_page'];
            $listaElementiPerPagina["{$this->limit}"] = $this->limit;
            $numeroElementiDefault = \is_callable($parameters['elements_per_page']) ? $parameters['elements_per_page']($form) :
                \is_null($parameters['elements_per_page']) ? \reset($listaElementiPerPagina) :
                $parameters['elements_per_page'];
            if (\is_int($numeroElementiDefault)) {
                $listaElementiPerPagina["$numeroElementiDefault"] = $numeroElementiDefault;
            }
            \asort($listaElementiPerPagina);

            $form->add('numero_elementi', ChoiceType::class, [
                'required' => false,
                'choices' => $listaElementiPerPagina,
                'placeholder' => false,
                'label' => 'Elementi per pagina',
                'mapped' => false,
                'data' => $numeroElementiDefault,
            ]);
        }        
    }
}
