<?php

namespace Schema31\UtilityBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * Description of LazyRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class LazyRepository extends EntityRepository {
    /**
     * Creates a new QueryBuilder instance that is prepopulated for this entity name.
     *
     * @param string $alias
     * @param string $indexBy the index for the from
     */
    public function createLazyQueryBuilder($alias, $indexBy = null): LazyQueryBuilder {
        $lazyQueryBuilder = new LazyQueryBuilder($this->_em);
        return $lazyQueryBuilder
            ->select($alias)
            ->from($this->_entityName, $alias, $indexBy);
    }
}
