<?php

namespace Schema31\UtilityBundle\Service\Ricerca;

use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\Query;
use Doctrine\ORM\QueryBuilder;
use Knp\Bundle\PaginatorBundle\Pagination\SlidingPagination;
use Knp\Component\Pager\PaginatorInterface;
use Schema31\UtilityBundle\Service\IRicerca;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\HttpFoundation\Request;

abstract class AbstractMethod implements IRicerca {
    /**
     * @var EntityManagerInterface
     */
    protected $entityManager;

    /**
     * @var PaginatorInterface
     */
    protected $paginator;

    /**
     * @var Request
     */
    protected $request;
    /**
     * @var FormFactoryInterface
     */
    protected $formFactory;

    /**
     * @var object|array|null
     */
    protected $data;

    /**
     * Numero default elementi per pagina
     * @var int
     */
    protected $numeroDefaultElementi;

    /**
     * Numero elementi selezionato dal form di ricerca
     * @var int|null
     */
    protected $limit;

    abstract public function pulisci(array $attributiRicerca): void;

    abstract public function ricerca(array $options = []): array;

    /**
     * @param iterable|Query|QueryBuilder $paginationObject
     * @return SlidingPagination
     */
    protected function paginate($paginationObject, int $index) {
        if (\is_int($this->limit)) {
            return $this->paginator->paginate(
                $paginationObject,
                $index,
                $this->limit
            );
        }

        if ($paginationObject instanceof QueryBuilder) {
            $paginationObject = $paginationObject->getQuery();
        }
        if ($paginationObject instanceof Query) {
            /** @var array */
            $paginationObject = $paginationObject->getResult();
        }

        return $this->paginator->paginate(
            $paginationObject,
            1,
            \count($paginationObject)
        );
    }
}
