<?php

namespace Schema31\UtilityBundle\Service;

use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Schema31\UtilityBundle\Service\Ricerca\Get;
use Schema31\UtilityBundle\Service\Ricerca\Post;
use Symfony\Component\Form\FormFactoryInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\HttpFoundation\Session\SessionInterface;

class RicercaFactory {
    /**
     * @var int
     */
    private $numeroElementi;
    /**
     * @var EntityManagerInterface
     */
    private $entityManager;
    /**
     * @var SessionInterface
     */
    private $session;
    /**
     * @var PaginatorInterface
     */
    private $paginator;
    /**
     * @var RequestStack
     */
    private $requestStack;
    /**
     * @var FormFactoryInterface
     */
    private $formFactory;

    public function __construct(
         $numeroElementi,
        EntityManagerInterface $entityManager,
        SessionInterface $session,
        PaginatorInterface $paginator,
        RequestStack $requestStack,
        FormFactoryInterface $formFactory
    ) {
        $this->numeroElementi = $numeroElementi;
        $this->entityManager = $entityManager;
        $this->session = $session;
        $this->paginator = $paginator;
        $this->requestStack = $requestStack;
        $this->formFactory = $formFactory;
    }

    public function createInstance(string $method): IRicerca {
        if ('GET' === $method) {
            return new Get(
                $this->numeroElementi,
                $this->entityManager,
                $this->paginator,
                $this->requestStack,
                $this->formFactory
            );
        }
        return new Post(
            $this->numeroElementi,
            $this->entityManager,
            $this->session,
            $this->paginator,
            $this->requestStack,
            $this->formFactory
        );
    }
}
