<?php
/**
 * Created by PhpStorm.
 * User: rstronati
 * Date: 07/01/16
 * Time: 13:03
 */

namespace Schema31\UtilityBundle\Model;

abstract class AttributiRicerca implements IAttributiRicerca {
    protected $numero_elementi;

    protected $filtro_attivo;

    protected $consenti_ricerca_vuota;

    protected $bypass_max_elementi_per_pagina = false;

    public function getNumeroElementi() {
        return $this->numero_elementi;
    }

    public function setNumeroElementi($numero_elementi) {
        $this->numero_elementi = $numero_elementi;
    }

    public function getFiltroAttivo() {
        return $this->filtro_attivo;
    }

    public function setFiltroAttivo($filtro_attivo) {
        $this->filtro_attivo = $filtro_attivo;
    }

    public function mostraNumeroElementi(): bool {
        return true;
    }

    public function isRicercaVuota(): bool {
        foreach ($this as $key => $value) {
            if (in_array($key, ["numero_elementi", "filtro_attivo", "consenti_ricerca_vuota", "bypass_max_elementi_per_pagina", "opzioni"])) {
                continue;
            }

            if (!is_null($value)) {
                return false;
            }
        }

        return true;
    }

    public function getConsentiRicercaVuota() {
        return $this->consenti_ricerca_vuota;
    }

    public function setConsentiRicercaVuota($consenti_ricerca_vuota) {
        $this->consenti_ricerca_vuota = $consenti_ricerca_vuota;
    }

    public function getBypassMaxElementiPerPagina() {
        return $this->bypass_max_elementi_per_pagina;
    }

    public function setBypassMaxElementiPerPagina($bypass_max_elementi_per_pagina) {
        $this->bypass_max_elementi_per_pagina = $bypass_max_elementi_per_pagina;
    }

    public function mergeFreshData($freshData) {
    }
}
