<?php

namespace Schema31\UtilityBundle\DependencyInjection;

use Schema31\UtilityBundle\Service\RicercaService;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\XmlFileLoader;

class Schema31UtilityExtension extends Extension {
    public function load(array $configs, ContainerBuilder $container) {
        $loader = new XmlFileLoader(
            $container,
            new FileLocator(__DIR__ . '/../Resources/config')
        );
        $loader->load('services.xml');

        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $definition = $container->getDefinition(RicercaService::class);
        $definition->replaceArgument(0, $config['ricerca']['max_elementi']);
        $definition->replaceArgument(1, $config['ricerca']['default_elementi']);
    }
}
