# UtilityBundle

Collezione di piccoli funzionalità di utilità

## Ricerca

### Requisiti

Per funzionare correttamente è necessario che sia installato ed utilizzato
 **doctrine** all'interno del progetto.

### Configurazione

Utilizzare un  file di configurazione come quello sotto:

```yaml
schema31_utility:
  ricerca:
    max_elementi: 10 #Numero massimo di elementi ammessi in ricerca
    default_elementi: 5 #Numero di default elementi di ricerca
```

### Come usare il bundle

Per implementare una ricerca è necessario implementare una classe che implementi
l'interfaccia _Schema31\UtilityBundle\Model\IAttributiRicerca_ o più semplicemente
estenda la classe _Schema31\UtilityBundle\Model\AttributiRicerca_.
Il nome del servizio è _Schema31\UtilityBundle\Service\RicercaService_

```php
    use Schema31\UtilityBundle\Service\RicercaService;

    function metodoRicerca(RicercaService $ricercaService){
    [..]
    $modello = new ModelloRicerca();
    $risultatoRicerca = $ricercaService->ricerca($modello);
    [..]
```
