<?php

namespace Schema31\Storage\Service;

/**
 * @author Antonio Turdo <aturdo@schema31.it>
 */
interface StorageInterface {
    
    /**
     * @param string $localFile
     * @param string|null $mime
     * @param string|null $publicName
     * @param string|null $fileKey
     * @return mixed la fileKey (string) oppure FALSE (bool) in caso di errore
     */
    public function sendFile(string $localFile, ?string $mime = null, ?string $publicName = NULL, ?string $fileKey = NULL);
    
    /**
     * @param string $fileKey
     * @param int|null $fileVersion
     * @return mixed i dettagli sul file (object) oppure FALSE in caso di errore
     */
    public function detailFile(string $fileKey, ?int $fileVersion = null);
    
    /**
     * @param string $fileKey
     * @param int|null $fileVersion
     * @return mixed il contenuto (string) del file richiesto oppure FALSE (bool) in caso di errore
     */
    public function getFile(string $fileKey, ?int $fileVersion = null);
    
    /**
     * @param string $fileKey
     * @param int|null $fileVersion
     * @return bool
     */
    public function streamFile(string $fileKey, ?int $fileVersion = null): bool;
    
    /**
     * @param string $fileKey
     * @param int|null $fileVersion
     * @return mixed i dettagli sul file cancellato (object) oppure FALSE in caso di errore
     */
    public function deleteFile(string $fileKey, ?int $fileVersion = null);
    
}
