<?php

namespace Schema31\SafeHubLib\Service;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

use Schema31\PHPOnCouch\Service\PHPOnCouchClient;
use Schema31\SafeHubLib\Service\EntityManager;
use Schema31\SafeHubLib\Service\UserService;

/**
 * Description of Container
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Container {
    
    public static function getInstance() {
        $container = new ContainerBuilder();
        $container->register("Schema31\SafeHubLib\Service\HubCouchDBClient", PHPOnCouchClient::class)
                ->addMethodCall("connect", ['%hub.couchdb.url%', '%hub.couchdb.db%', ['username' => '%hub.couchdb.username%', 'password' => '%hub.couchdb.password%']]);
        
        $container->register("Schema31\SafeHubLib\Service\HubEntityManager", EntityManager::class)
               ->addArgument(new Reference("Schema31\SafeHubLib\Service\HubCouchDBClient")); 
         
        $container->register("Schema31\SafeHubLib\Service\UserService", UserService::class)
               ->addArgument(new Reference("Schema31\SafeHubLib\Service\HubEntityManager"));          
        
        return $container;
    }
}
