<?php

namespace Schema31\SafeHubLib\Service;

use PHPMailer\PHPMailer\PHPMailer;

/**
 * Description of MailerFactory
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class MailerFactory {

    /**
     * 
     * @param string $protocol Actually, only "smtp" supported
     * @param array $protocolConfig For smtp availaible keys: host, user, pass, port, crypto
     * @param string|null $fromEmail
     * @param string|null $fromName
     */        
    public function createMailer(string $protocol, array $protocolConfig = [], ?string $fromEmail = null, ?string $fromName = null) {
        $phpMailer = new PHPMailer();
        $phpMailer->CharSet = 'UTF-8';
     
        switch ($protocol) {
            case 'smtp':
                $phpMailer->isSMTP();
                $phpMailer->Host = $protocolConfig['host'];
                $phpMailer->SMTPAuth = true;
                $phpMailer->Port = $protocolConfig['port'];
                $phpMailer->Username = $protocolConfig['user'];
                $phpMailer->Password = $protocolConfig['pass'];
                $phpMailer->SMTPSecure = $protocolConfig['crypto'];
                
                if ($fromEmail) {
                    $phpMailer->setFrom($fromEmail, $fromName ?? '');    
                }
        }

        return $phpMailer;
    }
}
