<?php

namespace Schema31\SafeHubLib\Repository;

use Schema31\CouchDBClient\Service\CouchDBClient;
use Schema31\CouchDBClient\Domain\ViewRequest;
use Schema31\Exceptions\Operation\UnexpectedException;

/**
 * Description of BaseRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class BaseRepository {
    protected $couchDBClient;
        
    public function __construct(CouchDBClient $couchDBClient) {
        $this->couchDBClient = $couchDBClient;
    }
    
    public function generateUUID() {
        $uuids = $this->couchDBClient->getUuids(1);
        return $uuids[0];       
    }
    
    protected function beforeSave(\stdClass $object) {
        $now = (new \DateTime())->format(\DateTime::ATOM);
        $object->UpdateDate = $now;
        
        if (!isset($object->CreationDate)) {
            $object->CreationDate = $now;
        }    
    } 

    public function save(\stdClass $object) {
        $this->beforeSave($object);
        $this->couchDBClient->storeDoc($object);
    } 
    
    protected function findOneByViewRequest(ViewRequest $viewRequest, array $details = []) {
        $viewResponse = $this->couchDBClient->getView($viewRequest);
        
        $results = $viewResponse->getDocs();
        
        if (count($results) > 1) {
            throw new UnexpectedException("findOneByViewRequest error, more than one result found: ". json_encode($details));
        } 
        
        $doc = count($results) == 0 ? null : $results[0];
        
        if (isset($doc->Disabled) && $doc->Disabled) {
            return null;
        }         
        
        return $doc;
    }
    
    public function getById($docId) {
        $doc = $this->couchDBClient->getDoc($docId);
                
        if (isset($doc->Disabled) && $doc->Disabled) {
            return null;
        } 
        
		return $doc;
    }
}
