<?php

namespace Schema31\SafeHubLib\IdentityProvider;

use Schema31\SafeHubLib\Exception\ValidationException;

/**
 * Description of GoogleIdentityProvider
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class GoogleIdentityProvider implements IdentityProviderInterface {
    const NO_ID_ERROR = "U-0012";
    const UNSUPPORTED_FEATURE_ERROR = "U-0018";
    
    public function supports(\stdClass $identity) {
        return isset($identity->Google);
    }

    public function normalize(\stdClass $identity) {
        if (isset($identity->Google->id)) {
			$identity->Google->LoginKey = $identity->Google->id;
		}       
    }

    public function getProviderKey() {
        return "Google";
    }

    public function finalize(\stdClass $identity) {
        
    }

    public function isEmailVerified() {
        return true;
    }

    public function validate(\stdClass $identity) {
        if (!isset($identity->Google->userId)) {
            throw new ValidationException(self::NO_ID_ERROR, "No Google id provided");
		}        
    }

    public function checkCredentials(\stdClass $identity, \stdClass $physicalEntity) {
        return true;
    }

    public function forgottenCredentials(\stdClass $physicalEntity) {
        throw new ValidationException(self::UNSUPPORTED_FEATURE_ERROR, "Feature not supported");
    }

    public function changeCredentials(\stdClass $physicalEntity, \stdClass $changeCredentials) {
        throw new ValidationException(self::UNSUPPORTED_FEATURE_ERROR, "Feature not supported");
    }

    public function confirmRegistration(\stdClass $physicalEntity, string $verificationCode) {
        throw new ValidationException(self::UNSUPPORTED_FEATURE_ERROR, "Feature not supported");
    }
}
