<?php

namespace Schema31\SafeHubLib\StorageProvider;
use Schema31\Exceptions\Operation\UnexpectedException;

require_once "Cloud31_Storage31/Cloud31_Storage31.php";

/**
 * Description of Storage31Provider
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Storage31Provider {
    private $storage31Client;
    
    public function __construct(string $authentication, ?string $host = NULL, ?string $protocol = NULL) {
        $this->storage31Client = new \Cloud31_Storage31();
		$this->storage31Client->Authentication = $authentication;
        
        if ($host) {
            $this->storage31Client->Storage31Host = $host;
            $this->storage31Client->gCloudStorageHost = $host;
        } 
        
        if ($protocol) {
            $this->storage31Client->protocol = $protocol;
        }
    }
    
    public function getShortUrl($file){
        if (!isset($file->Repository) || !isset($file->Reference)) {
            throw new UnexpectedException("Repository or reference not found on RawFile");
        }
        
        $this->storage31Client->repositoryName = $file->Repository;
		
		$shortUrl =  $this->storage31Client->getShortUrl($file->Reference);
        
        if (!$shortUrl) {
            throw new UnexpectedException($this->storage31Client->LastError);
        }
        
        return $shortUrl;
    }
    
    public function getFile($file){
        if (!isset($file->Repository) || !isset($file->Reference)) {
            throw new UnexpectedException("Repository or reference not found on RawFile");
        }
        
        $this->storage31Client->repositoryName = $file->Repository;
		
		$content = $this->storage31Client->getFile($file->Reference);
        
        if (!$content) {
            throw new UnexpectedException($this->storage31Client->LastError);
        }
        
        $fileResult = new \Schema31\SafeHubLib\Model\File($content);
         
        if (isset($this->storage31Client->ResponseHeaders["content-disposition"])) {
            $matches = [];
            preg_match("/filename=\"([^\"]*)\"/", $this->storage31Client->ResponseHeaders["content-disposition"], $matches);
            
            if (count($matches) > 1) {
                $fileResult->setName($matches[1]);
            }
        }
        
        if (isset($this->storage31Client->ResponseHeaders["content-length"])) {
            $fileResult->setLength((int) $this->storage31Client->ResponseHeaders["content-length"]);
        }  
        
        if (isset($this->storage31Client->ResponseHeaders["content-type"])) {
            $fileResult->setContentType($this->storage31Client->ResponseHeaders["content-type"]);
        }          
        
        return $fileResult;
    }    
}
