<?php

namespace Schema31\SafeHubLib\Service;

use Schema31\Exceptions\Operation\ForbiddenException;

use Schema31\SafeHubLib\Service\UserService;
use Schema31\SafeHubLib\Service\EntityManager;

/**
 * Description of StorageService
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class DocumentService {
    
    private $em;
    
    public function __construct(EntityManager $entityManager) {
        $this->em = $entityManager;
    }
    
    public function checkAccessByUserId($document, $userId) {
        $user = $this->em->getRepository(UserService::PHYSICAL_ENTITY)->getById($userId);
        $this->checkAccessByUser($document, $user);
    }
	
	public function checkAccessByUser($document, $user){
		if(!isset($user->Roles) || !is_array($user->Roles) || count($user->Roles) == 0){
			throw new ForbiddenException("User does not have the rights to access the invoice");
		}
		
		foreach ($user->Roles as $role) {
			if($role->legalEntity == $document->Owner->legalEntity){
				if(!isset($role->Division)){
					return;
				}
				if($role->Division == $document->Owner->Division){
					return;
				}
			}
		}
		
		throw new ForbiddenException("User does not have the rights to access the invoice");
	}
}
