<?php

namespace Schema31\SafeHubLib\Service;

use Schema31\Exceptions\Operation\ForbiddenException;

use Schema31\SafeHubLib\Service\UserService;
use Schema31\SafeHubLib\Service\EntityManager;

/**
 * Description of InvoiceService
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class InvoiceService {
	const INVOICE = 'Invoice';
	
    private $em;
    
    public function __construct(EntityManager $entityManager) {
        $this->em = $entityManager;
    }
	
	private function checkAccess($invoice, $user){
		if(!isset($user->Roles) || !is_array($user->Roles) || count($user->Roles) == 0){
			return FALSE;
		}
		
		foreach ($user->Roles as $role) {
			if($role->legalEntity == $invoice->Owner->legalEntity){
				if(!isset($role->Division)){
					return TRUE;
				}
				if($role->Division == $invoice->Owner->Division){
					return TRUE;
				}
			}
		}
		
		return FALSE;
	}
	
	public function markAsSeen(string $invoiceId, string $userId){
		$invoice = $this->em->getRepository(self::INVOICE)->getById($invoiceId);
		
		$user = $this->em->getRepository(UserService::PHYSICAL_ENTITY)->getById($userId);
		
		if (!$this->checkAccess($invoice, $user)) {
			throw new ForbiddenException("User does not have the rights to access the invoice");
		}
		
		if(!isset($invoice->SeenBy)){
			$invoice->SeenBy = new \stdClass();
		}
		
		if(!isset($invoice->SeenBy->Users)){
			$invoice->SeenBy->Users = [];
		}
		
		if(!in_array($userId, $invoice->SeenBy->Users)){
			$invoice->SeenBy->Users[] = $userId;
		}
		
		$this->em->getRepository(self::INVOICE)->save($invoice);
	}
}
