<?php

namespace Schema31\SafeHubLib\Service;

use Schema31\Exceptions\Operation\UnexpectedException;
use Schema31\CouchDBClient\Service\CouchDBClient;

/**
 * Description of EntityManager
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class EntityManager {

    private $repositories;
    private $client;
    
    public function __construct(CouchDBClient $client) {
        $this->repositories = [];
        $this->client = $client;
    }

    public function getRepository($model): \Schema31\SafeHubLib\Repository\BaseRepository {
        if (!array_key_exists($model, $this->repositories)) {
            $class = "\\Schema31\\SafeHubLib\\Repository\\".$model."Repository";
            if (class_exists($class)) {
                $this->repositories[$model] = new $class($this->client);
            } else {
                throw new UnexpectedException("$model repository not found");
            }
        }
        
        return $this->repositories[$model];
    }
}
