<?php

namespace Schema31\SafeHubLib\Repository;

use Schema31\CouchDBClient\Service\CouchDBClient;
use Schema31\CouchDBClient\Domain\ViewRequest;
use Schema31\SafeHubLib\Exception\UnexpectedException;

/**
 * Description of BaseRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class BaseRepository {
    protected $couchDBClient;
    
    const COUCHDB_GENERIC_ERROR = '0002';
    const NOT_UNIQUE_RESULT_ERROR = '0003';
	const NOT_FOUND_ERROR = '0004';
        
    public function __construct(CouchDBClient $couchDBClient) {
        $this->couchDBClient = $couchDBClient;
    }
    
    public function generateUUID() {
        $uuids = $this->couchDBClient->getUuids(1);
        return $uuids[0];       
    }
    
    protected function beforeSave(\stdClass $object) {
        $now = (new \DateTime())->format(\DateTime::ATOM);
        $object->UpdateDate = $now;
        
        if (!isset($object->CreationDate)) {
            $object->CreationDate = $now;
        }    
    } 

    public function save(\stdClass $object) {
        $this->beforeSave($object);
        $this->couchDBClient->storeDoc($object);
    } 
    
    protected function findOneByViewRequest(ViewRequest $viewRequest, array $details = []) {
        $details[] = get_class();
        
        $viewResponse = $this->couchDBClient->getView($viewRequest);
        
        $results = $viewResponse->getDocs();
        
        if (count($results) > 1) {
            throw new UnexpectedException(self::NOT_UNIQUE_RESULT_ERROR, "findOneByViewRequest error, more than one result found: ". json_encode($details));
        } 
        
        return count($results) == 0 ? null : $results[0];
    }
    
    public function getById($docId) {
		return $this->couchDBClient->getDoc($docId);
    }
}
