<?php

namespace Schema31\SafeHubLib\Service;

use Schema31\SafeHubLib\Exception\ValidationException;

/**
 * Description of PhysicalEntityService
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class PhysicalEntityService {
    
    const PHYSICAL_ENTITY_FISCALCODE_ERROR = "PE-0003";
    
    public function validate($physicalEntity) {
        if(!isset($physicalEntity->FiscalCode) & strlen($physicalEntity->FiscalCode) != 16){
            throw new ValidationException(self::PHYSICAL_ENTITY_FISCALCODE_ERROR, "Fiscal code not found or not valid");
        }

        $regexValidation = "/^[A-Z|a-z|]{6}\d{2}[A-Z|a-z|]\d{2}[A-Z|a-z|]\d{3}[A-Z|a-z|]$/";
        if(!preg_match($regexValidation, $physicalEntity->FiscalCode)){
            throw new ValidationException(self::PHYSICAL_ENTITY_FISCALCODE_ERROR, "Fiscal code not valid");
        }        
    }
}
