<?php

namespace Schema31\SafeHubLib\Service;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

use Schema31\PHPOnCouch\Service\PHPOnCouchClient;
use Schema31\SafeHubLib\Service\EntityManager;
use Schema31\SafeHubLib\Service\UserService;
use Twig\Loader\FilesystemLoader;
use Twig\Environment;
use Symfony\Component\Translation\Translator;
use Schema31\GCloudMonitoringMonologHandler\GCloudMonitoringHandler;
use Monolog\Logger;

/**
 * Description of Container
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Container {
    
    public static function getInstance() {
        $container = new ContainerBuilder();

        $container->register("Schema31\SafeHubLib\Service\MonologHandler", GCloudMonitoringHandler::class)
               ->addArgument('%hub.logger.target%')
               ->addArgument('%hub.logger.authentication%');

        $container->register("Schema31\SafeHubLib\Service\Logger", Logger::class)
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\MonologHandler")); 
        
        $container->register("Schema31\SafeHubLib\Service\TemplateLoader", FilesystemLoader::class)
               ->addArgument(__DIR__ . "/../Template");    
        
        $container->register("Schema31\SafeHubLib\Service\Templating", Environment::class)
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\TemplateLoader"));   

        $container->register("Schema31\SafeHubLib\Service\Translator", Translator::class)
                ->addArgument("it")
                ->addMethodCall("addLoader", ['yaml', new \Symfony\Component\Translation\Loader\YamlFileLoader()])
                ->addMethodCall("addResource", ['yaml', __DIR__ . "/../Translation/messages.en.yml", "en"])
                ->addMethodCall("addResource", ['yaml', __DIR__ . "/../Translation/messages.it.yml", "it"]);     
        
        $container->register("Schema31\SafeHubLib\Service\Mailer")
                ->setFactoryClass(MailerFactory::class)
                ->setFactoryMethod("createMailer")
                ->addArgument('%hub.mailer.protocol%')
                ->addArgument('%hub.mailer.protocolConfig%')
                ->addArgument('%hub.mailer.fromEmail%')
                ->addArgument('%hub.mailer.fromName%')
                ;
        
        $container->register("Schema31\SafeHubLib\Service\HubCouchDBClient", PHPOnCouchClient::class)
                ->addMethodCall("connect", ['%hub.couchdb.url%', '%hub.couchdb.db%', ['username' => '%hub.couchdb.username%', 'password' => '%hub.couchdb.password%']]);
        
        $container->register("Schema31\SafeHubLib\Service\HubEntityManager", EntityManager::class)
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\HubCouchDBClient")); 
         
        $container->register("Schema31\SafeHubLib\Service\UserService", UserService::class)
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\HubEntityManager"))
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\Templating"))
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\Translator"))
                ->addArgument(new Reference("Schema31\SafeHubLib\Service\Mailer"));


        
        return $container;
    }
}
