<?php

namespace Schema31\SafeHubLib\Repository;

use Schema31\CouchDBClient\Domain\ViewRequest;

/**
 * Description of PhysicalEntityRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class PhysicalEntityRepository extends BaseRepository {
    
    public function findOneByFiscalCode(string $fiscalCode) {
        $viewRequest = new ViewRequest("physicalEntities", "byFiscalCode");
        $viewRequest->partialKey($fiscalCode);
        $viewRequest->includeDocs(true);
                
        return $this->findOneByViewRequest($viewRequest, ["findOneByFiscalCode", $fiscalCode]);        
    }
    
    public function findOneByEmail(string $email, bool $verified = true) {
        $viewRequest = new ViewRequest("physicalEntities", "byEmail");
        $viewRequest->partialKey([$email, $verified]);
        $viewRequest->includeDocs(true);
        
        return $this->findOneByViewRequest($viewRequest, ["findOneByEmail", $email, $verified]);         
    }    

    public function findOneByIdentity(string $providerKey, string $loginKey) {
        $viewRequest = new ViewRequest("users", "byProviderId");
        $viewRequest->partialKey([$providerKey, $loginKey]);
        $viewRequest->includeDocs(true);

        return $this->findOneByViewRequest($viewRequest, ["findOneByIdentity", $providerKey, $loginKey]);
    }  

    public function generateId(string $fiscalCode) {        
        return "PE.$fiscalCode.".$this->generateUUID();
    }

}
