<?php

namespace Schema31\SafeHubLib\Repository;

use Schema31\CouchDBClient\Domain\ViewRequest;

/**
 * Description of LegalEntityRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class LegalEntityRepository extends BaseRepository {
    
    public function findOneByFiscalCode(string $fiscalCode) {
        // eventualmente aggiungere una vista per il solo codice fiscale
        $viewRequest = new ViewRequest("legalEntities", "allByVAT");
        $viewRequest->partialKey([$fiscalCode]);
        $viewRequest->includeDocs(true);
        
        return $this->findOneByViewRequest($viewRequest, ["findOneByFiscalCode", $fiscalCode]);      
    } 
    
    public function generateId(string $fiscalCode) {        
        return "LE:$fiscalCode.".$this->generateUUID();
    }    

}
