<?php

namespace Schema31\SafeHubLib\Service;

use PHPMailer\PHPMailer\PHPMailer;

/**
 * Description of Mailer
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Mailer {
    
    private $phpMailer;
    
    /**
     * 
     * @param string $protocol Actually, only "smtp" supported
     * @param array $protocolConfig For smtp availaible keys: host, user, pass, port, crypto
     * @param string|null $fromEmail
     * @param string|null $fromName
     */
    public function __construct(string $protocol, array $protocolConfig = [], ?string $fromEmail = null, ?string $fromName = null) {
        $this->phpMailer = new PHPMailer();
        
        switch ($protocol) {
            case 'smtp':
                $this->phpMailer->isSMTP();
                $this->phpMailer->Host = $protocolConfig['host'];
                $this->phpMailer->SMTPAuth = true;
                $this->phpMailer->Port = $protocolConfig['port'];
                $this->phpMailer->Username = $protocolConfig['user'];
                $this->phpMailer->Password = $protocolConfig['pass'];
                $this->phpMailer->SMTPSecure = $protocolConfig['crypto'];
                
                if ($fromEmail) {
                    $this->phpMailer->setFrom($fromEmail, $fromName ?? '');    
                }
        }
    }
    
    public function __call($name, $arguments) {
        $this->phpMailer->$name(...$arguments);
    }

}
