<?php

namespace Schema31\SafeHubLib\IdentityProvider;

use Schema31\SafeHubLib\Exception\ValidationException;

/**
 * Description of FacebookIdentityProvider
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class FacebookIdentityProvider implements IdentityProviderInterface {
    const NO_USER_ID_ERROR = "U-0012";
    const UNSUPPORTED_FEATURE_ERROR = "U-0018";
    
    public function supports(\stdClass $identity) {
        return isset($identity->Facebook);
    }

    public function normalize(\stdClass $identity) {
        if (isset($identity->Facebook->userId)) {
			$identity->Facebook->LoginKey = $identity->Facebook->userId;
		}          
    }

    public function getProviderKey() {
        return "Facebook";
    }

    public function finalize(\stdClass $identity) {
        
    }

    public function isEmailVerified() {
        return true;
    }

    public function validate(\stdClass $identity) {
        if (!isset($identity->Facebook->userId)) {
            throw new ValidationException(self::NO_USER_ID_ERROR, "No Facebook user id provided");
		}          
    }

    public function checkCredentials(\stdClass $identity, \stdClass $physicalEntity) {
        // @todo: implementare controllo credenziali lato server
        return true;
    }

    public function forgottenCredentials(\stdClass $physicalEntity) {
        throw new ValidationException(self::UNSUPPORTED_FEATURE_ERROR, "Feature not supported");
    }

    public function changeCredentials(\stdClass $physicalEntity, \stdClass $changeCredentials) {
        throw new ValidationException(self::UNSUPPORTED_FEATURE_ERROR, "Feature not supported");
    }

}
