<?php

namespace Schema31\SafeHubLib\Repository;

use Schema31\CouchDBClient\Service\CouchDBClient;

/**
 * Description of BaseRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class BaseRepository {
    protected $couchDBClient;
    
    const COUCHDB_GENERIC_ERROR = '0002';
    const NOT_UNIQUE_RESULT_ERROR = '0003';
        
    public function __construct(CouchDBClient $couchDBClient) {
        $this->couchDBClient = $couchDBClient;
    }
    
    public function generateUUID() {
        try {
            $uuids = $this->couchDBClient->getUuids(1);
            return $uuids[0];
        } catch (\Exception $e) {
            throw new UnexpectedException(self::COUCHDB_GENERIC_ERROR, "Error retrieving UUIDs");
        }        
    }
}
