<?php

namespace Schema31\SafeHubLib\IdentityProvider;

/**
 * Description of SafeIdentityProvider
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class SafeIdentityProvider implements IdentityProviderInterface {
    
    public function supports(\stdClass $identity) {
        return isset($identity->Safe);
    }

    public function normalize(\stdClass $identity) {
        if (isset($identity->Safe->Username)) {
            $identity->Safe->Username = strtolower($identity->Safe->Username);
            $identity->Safe->LoginKey = $identity->Safe->Username;
        }		        
    }

    public function getProviderKey() {
        return "Safe";
    }

    public function finalize(\stdClass $identity) {
        $password = $identity->Safe->Password;
        $passwordCripted = $this->_crypt_password($password);
        $identity->Safe->Password = $passwordCripted;        
    }

	private function _crypt_password($input) {
		$crypt_options = [
		  'cost' => 10
		];
        
		return password_hash($input, PASSWORD_BCRYPT, $crypt_options);
	}

    public function validate(\stdClass $identity) {
    	if(!isset($identity->Safe->Password)){
            throw new \Exception();
        }
    }

    public function isEmailVerified() {
        return false;
    }

}
