<?php

namespace Schema31\SafeHubLib\IdentityProvider;

/**
 * Description of FacebookIdentityProvider
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class FacebookIdentityProvider implements IdentityProviderInterface {
    
    public function supports(\stdClass $identity) {
        return isset($identity->Facebook);
    }

    public function normalize(\stdClass $identity) {
        if (isset($identity->Google->userId)) {
			$identity->Google->LoginKey = $identity->Google->userId;
		}          
    }

    public function getProviderKey() {
        return "Facebook";
    }

    public function finalize(\stdClass $identity) {
        
    }

    public function isEmailVerified() {
        return true;
    }

    public function validate(\stdClass $identity) {
        
    }

}
