<?php

namespace Schema31\SafeHubLib\Infrastructure\Repository\CouchDB;

use Schema31\SafeHubLib\Domain\Repository\PhysicalEntityRepositoryInterface;
use Schema31\CouchDBClient\Service\CouchDBClient;

use Schema31\CouchDBClient\Domain\ViewRequest;

/**
 * Description of PhysicalEntityRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class PhysicalEntityRepository implements PhysicalEntityRepositoryInterface {
    private $couchDBClient;
    
    public function __construct(CouchDBClient $couchDBClient) {
        $this->couchDBClient = $couchDBClient;
    }
    
    public function findOneByFiscalCode(string $fiscalCode) {
        $viewRequest = new ViewRequest("physicalEntities", "byFiscalCode");
        $viewRequest->partialKey($fiscalCode);
        $viewRequest->includeDocs(true);
        
        $viewResponse = $this->couchDBClient->getView($viewRequest);
        $results = $viewResponse->getDocs();
        
        if (count($results) > 1) {
            throw new \Exception();
        }
        
        return count($results) == 0 ? null : $results[0];        
    }

    public function findOneByIdentity(string $providerKey, string $loginKey) {
        $viewRequest = new ViewRequest("users", "byProviderId");
        $viewRequest->partialKey([$providerKey, $loginKey]);
        $viewRequest->includeDocs(true);
        
        $viewResponse = $this->couchDBClient->getView($viewRequest);
        $results = $viewResponse->getDocs();
        
        if (count($results) > 1) {
            throw new \Exception();
        }
        
        return count($results) == 0 ? null : $results[0];
    }

    public function save(\stdClass $physicalEntity) {
        $this->couchDBClient->storeDoc($physicalEntity);
    }

}
