<?php

namespace Schema31\SafeHubLib\Infrastructure\IdentityProvider;

use Schema31\SafeHubLib\Domain\IdentityProviderInterface;

/**
 * Description of GoogleIdentityProvider
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class GoogleIdentityProvider implements IdentityProviderInterface {
    
    public function supports(\stdClass $identity) {
        return isset($identity->Google);
    }

    public function normalize(\stdClass $identity) {
        if (isset($identity->Google->id)) {
			$identity->Google->LoginKey = $identity->Google->id;
		}       
    }

    public function getProviderKey() {
        return "Google";
    }

    public function finalize(\stdClass $identity) {
        
    }

    public function isEmailVerified() {
        return true;
    }

    public function validate(\stdClass $identity) {
        
    }

}
