<?php

namespace Test;

use PHPUnit\Framework\TestCase;
use Schema31\PrometheusClient\Storage\PDOAdapter;

class PDOAdapterTest extends TestCase {
    /**
     * @var \PDO
     */
    private $pdo;

    /**
     * @var PDOAdapter
     */
    private $adapter;

    public function setUp() {
        parent::setUp();
        $this->pdo = new \PDO("mysql:dbname={$GLOBALS['dbName']};host={$GLOBALS['host']}", $GLOBALS['username'], $GLOBALS['password']);
        $this->cleanDB();
        $this->adapter = new PDOAdapter($this->pdo);
    }

    private function cleanDB() {
        $this->pdo->exec("DROP TABLE IF EXISTS " . PDOAdapter::DEFAULT_TABLE_NAME);
    }

    public function testHasValueNonPresente(): void {
        $res = $this->adapter->hasValue('key', []);

        $this->assertFalse($res);
    }

    public function testHasValueSePresente(): void {
        $this->adapter->setValue('key', 1.0, []);

        $res = $this->adapter->hasValue('key', []);

        $this->assertTrue($res);
    }

    public function testGetValue(): void {
        $this->adapter->setValue('key', 1.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(1.0, $res);
    }

    public function testGetValueNonPresente(): void {
        $res = $this->adapter->getValue('key', []);

        $this->assertNull($res);
    }

    public function testGetValuesVuoto(): void {
        $res = $this->adapter->getValues('key');

        $this->assertEmpty($res);
    }

    public function testGetValuesUnValore(): void {
        $this->adapter->setValue('key', 1.0, ['label']);

        $res = $this->adapter->getValues('key');

        $this->assertCount(1, $res);
        $this->assertCount(2, $res[0]);
        $this->assertEquals(1.0, $res[0][0]);
        $this->assertEquals(['label'], $res[0][1]);
    }

    public function testGetValuesDueValori(): void {
        $this->adapter->setValue('key2', 1.0, ['label']);
        $this->adapter->setValue('key2', 2.0, ['label2']);

        $res = $this->adapter->getValues('key2');

        $this->assertCount(2, $res);
    }

    public function testIncrementFloatDefault(): void {
        $this->adapter->incValue('key', 1.0, 0.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(1.0, $res);
    }

    public function testIncrementCallableDefault(): void {
        $this->adapter->incValue('key', 1.0, function () {
            return 2.0;
        }, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(3.0, $res);
    }

    public function testIncrementValueAlreadyExists(): void {
        $this->adapter->setValue('key', 1.0, []);

        $this->adapter->incValue('key', 1.0, 0.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(2.0, $res);
    }

    public function testGetPrefix(): void {
        $res = $this->adapter->getPrefix();

        $this->assertEquals('', $res);
    }

    public function testBigValues(): void {
        $value = [
            'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam vel odio leo. Curabitur ut condimentum ex. Etiam accumsan non dolor placerat condimentum. Etiam in vehicula eros. Mauris in tellus vitae augue cursus tempor a et nibh. Aliquam felis libero, tincidunt viverra aliquam quis, sollicitudin in augue. Suspendisse accumsan, sem tincidunt molestie accumsan, nisl nisl efficitur lacus, ac lobortis nunc elit luctus nulla. Maecenas convallis ligula id massa lacinia suscipit. Etiam euismod gravida laoreet. Mauris eu felis et felis efficitur bibendum a nec mi. Praesent imperdiet, urna ut euismod pharetra, ante purus vestibulum dui, at ornare neque tortor vitae ante. Nulla commodo turpis eu nulla gravida eleifend. Phasellus consectetur sapien dolor, eu lacinia odio fermentum vel. Ut vestibulum dui turpis, consequat dictum nunc tempor hendrerit. Vivamus pellentesque porttitor sem, ornare pretium odio vehicula nec. Nunc faucibus ipsum in justo laoreet molestie.

            Maecenas imperdiet nulla interdum erat molestie, vitae dapibus ligula vulputate. Curabitur quis ante non erat luctus pharetra eu sed urna. Vestibulum vulputate, quam eget laoreet varius, orci elit molestie est, quis maximus tellus orci id urna. Nam quis augue vulputate, porttitor felis non, feugiat nunc. Curabitur facilisis euismod libero. Nam non velit sagittis, egestas lacus vitae, vulputate orci. Donec at ligula sit amet massa finibus rutrum. Suspendisse potenti.
            
            Nam sit amet cursus felis, eu tristique mi. Ut sapien velit, dapibus ac porttitor et, tempor ut est. Sed purus libero, consectetur vitae pellentesque id, posuere vitae elit. Nulla aliquet urna sem, id iaculis neque pulvinar non. Curabitur varius suscipit tincidunt. Nulla pretium iaculis mi, ac fermentum tortor congue ac. Fusce vitae pharetra purus. Etiam id turpis hendrerit, rhoncus enim rhoncus, eleifend urna. Morbi sed tellus vitae nunc tincidunt porta. Nullam ut pellentesque nisi. Aenean dictum nisi a semper eleifend. Maecenas bibendum gravida maximus.
            
            Suspendisse tincidunt diam in vulputate molestie. Curabitur tristique tincidunt varius. Vivamus sed nulla ac urna tempor laoreet. Donec condimentum purus quis nisl tristique elementum. Donec venenatis convallis ex, sit amet sagittis lacus. Donec maximus erat semper tortor condimentum varius. Pellentesque ullamcorper mi et rhoncus euismod. Aenean varius facilisis risus, quis gravida mi blandit a.
            
            Etiam ac aliquam mi. Sed sem ex, laoreet in tincidunt sit amet, finibus eget metus. Sed at pulvinar ligula. Etiam tempor quam ut posuere faucibus. Nulla laoreet dapibus nunc a gravida. Donec mollis fermentum ipsum ac euismod. Pellentesque euismod ac ante ut tristique. Nam vitae lacus dolor.' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam vel odio leo. Curabitur ut condimentum ex. Etiam accumsan non dolor placerat condimentum. Etiam in vehicula eros. Mauris in tellus vitae augue cursus tempor a et nibh. Aliquam felis libero, tincidunt viverra aliquam quis, sollicitudin in augue. Suspendisse accumsan, sem tincidunt molestie accumsan, nisl nisl efficitur lacus, ac lobortis nunc elit luctus nulla. Maecenas convallis ligula id massa lacinia suscipit. Etiam euismod gravida laoreet. Mauris eu felis et felis efficitur bibendum a nec mi. Praesent imperdiet, urna ut euismod pharetra, ante purus vestibulum dui, at ornare neque tortor vitae ante. Nulla commodo turpis eu nulla gravida eleifend. Phasellus consectetur sapien dolor, eu lacinia odio fermentum vel. Ut vestibulum dui turpis, consequat dictum nunc tempor hendrerit. Vivamus pellentesque porttitor sem, ornare pretium odio vehicula nec. Nunc faucibus ipsum in justo laoreet molestie.

            Maecenas imperdiet nulla interdum erat molestie, vitae dapibus ligula vulputate. Curabitur quis ante non erat luctus pharetra eu sed urna. Vestibulum vulputate, quam eget laoreet varius, orci elit molestie est, quis maximus tellus orci id urna. Nam quis augue vulputate, porttitor felis non, feugiat nunc. Curabitur facilisis euismod libero. Nam non velit sagittis, egestas lacus vitae, vulputate orci. Donec at ligula sit amet massa finibus rutrum. Suspendisse potenti.
            
            Nam sit amet cursus felis, eu tristique mi. Ut sapien velit, dapibus ac porttitor et, tempor ut est. Sed purus libero, consectetur vitae pellentesque id, posuere vitae elit. Nulla aliquet urna sem, id iaculis neque pulvinar non. Curabitur varius suscipit tincidunt. Nulla pretium iaculis mi, ac fermentum tortor congue ac. Fusce vitae pharetra purus. Etiam id turpis hendrerit, rhoncus enim rhoncus, eleifend urna. Morbi sed tellus vitae nunc tincidunt porta. Nullam ut pellentesque nisi. Aenean dictum nisi a semper eleifend. Maecenas bibendum gravida maximus.
            
            Suspendisse tincidunt diam in vulputate molestie. Curabitur tristique tincidunt varius. Vivamus sed nulla ac urna tempor laoreet. Donec condimentum purus quis nisl tristique elementum. Donec venenatis convallis ex, sit amet sagittis lacus. Donec maximus erat semper tortor condimentum varius. Pellentesque ullamcorper mi et rhoncus euismod. Aenean varius facilisis risus, quis gravida mi blandit a.
            
            Etiam ac aliquam mi. Sed sem ex, laoreet in tincidunt sit amet, finibus eget metus. Sed at pulvinar ligula. Etiam tempor quam ut posuere faucibus. Nulla laoreet dapibus nunc a gravida. Donec mollis fermentum ipsum ac euismod. Pellentesque euismod ac ante ut tristique. Nam vitae lacus dolor.',
        ];
        $this->adapter->setValue('key', 1.0, $value);

        $res = $this->adapter->getValue('key', $value);

        $this->assertEquals(1.0, $res);
    }
}
