<?php

namespace Test;

use PHPUnit\Framework\TestCase;
use Schema31\PrometheusClient\Storage\PDOAdapter;

class PDOAdapterTest extends TestCase {
    /**
     * @var \PDO
     */
    private $pdo;

    /**
     * @var PDOAdapter
     */
    private $adapter;

    public function setUp() {
        parent::setUp();
        $this->pdo = new \PDO("mysql:dbname={$GLOBALS['dbName']};host={$GLOBALS['host']}", $GLOBALS['username'], $GLOBALS['password']);
        $this->cleanDB();
        $this->adapter = new PDOAdapter($this->pdo);
    }

    private function cleanDB() {
        $this->pdo->exec("DROP TABLE IF EXISTS " . PDOAdapter::DEFAULT_TABLE_NAME);
    }

    public function testHasValueNonPresente(): void {
        $res = $this->adapter->hasValue('key', []);

        $this->assertFalse($res);
    }

    public function testHasValueSePresente(): void {
        $this->adapter->setValue('key', 1.0, []);

        $res = $this->adapter->hasValue('key', []);

        $this->assertTrue($res);
    }

    public function testGetValue(): void {
        $this->adapter->setValue('key', 1.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(1.0, $res);
    }

    public function testGetValueNonPresente(): void {
        $res = $this->adapter->getValue('key', []);

        $this->assertNull($res);
    }

    public function testGetValuesVuoto(): void {
        $res = $this->adapter->getValues('key');

        $this->assertEmpty($res);
    }

    public function testGetValuesUnValore(): void {
        $this->adapter->setValue('key', 1.0, ['label']);

        $res = $this->adapter->getValues('key');

        $this->assertCount(1, $res);
        $this->assertCount(2, $res[0]);
        $this->assertEquals(1.0, $res[0][0]);
        $this->assertEquals(['label'], $res[0][1]);
    }

    public function testGetValuesDueValori(): void {
        $this->adapter->setValue('key2', 1.0, ['label']);
        $this->adapter->setValue('key2', 2.0, ['label2']);

        $res = $this->adapter->getValues('key2');

        $this->assertCount(2, $res);
    }

    public function testIncrementFloatDefault(): void {
        $this->adapter->incValue('key', 1.0, 0.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(1.0, $res);
    }

    public function testIncrementCallableDefault(): void {
        $this->adapter->incValue('key', 1.0, function () {
            return 2.0;
        }, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(3.0, $res);
    }

    public function testIncrementValueAlreadyExists(): void {
        $this->adapter->setValue('key', 1.0, []);

        $this->adapter->incValue('key', 1.0, 0.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(2.0, $res);
    }

    public function testGetPrefix(): void {
        $res = $this->adapter->getPrefix();

        $this->assertEquals('', $res);
    }
}
