<?php

namespace Test;

use PHPUnit\Framework\TestCase;
use Schema31\PrometheusClient\Storage\MysqliAdapter;

class AdapterTest extends TestCase {
    /**
     * @var MysqliAdapter
     */
    private $adapter;

    public function setUp() {
        $this->cleanDB();
        $this->adapter = new MysqliAdapter("mysql://{$GLOBALS['username']}:{$GLOBALS['password']}@{$GLOBALS['host']}:3306/{$GLOBALS['dbName']}");

        /* activate reporting */
        // $driver = new \mysqli_driver();
        // $driver->report_mode = MYSQLI_REPORT_ALL;
    }

    private function cleanDB() {
        $connection = new \mysqli($GLOBALS['host'], $GLOBALS['username'], $GLOBALS['password'], $GLOBALS['dbName']);
        /* check connection */
        if (\mysqli_connect_errno()) {
            printf("Connect failed: %s\n", \mysqli_connect_error());
            exit();
        }
        $connection->query("DROP TABLE IF EXISTS " . MysqliAdapter::DEFAULT_TABLE_NAME);
        $connection->close();
    }

    public function testHasValueNonPresente(): void {
        $res = $this->adapter->hasValue('key', []);

        $this->assertFalse($res);
    }

    public function testHasValueSePresente(): void {
        $this->adapter->setValue('key', 1.0, []);

        $res = $this->adapter->hasValue('key', []);

        $this->assertTrue($res);
    }

    public function testGetValue(): void {
        $this->adapter->setValue('key', 1.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(1.0, $res);
    }

    public function testGetValueNonPresente(): void {
        $res = $this->adapter->getValue('key', []);

        $this->assertNull($res);
    }

    public function testGetValuesVuoto(): void {
        $res = $this->adapter->getValues('key');

        $this->assertEmpty($res);
    }

    public function testGetValuesUnValore(): void {
        $this->adapter->setValue('key', 1.0, ['label']);

        $res = $this->adapter->getValues('key');

        $this->assertCount(1, $res);
        $this->assertCount(2, $res[0]);
        $this->assertEquals(1.0, $res[0][0]);
        $this->assertEquals(['label'], $res[0][1]);
    }

    public function testGetValuesDueValori(): void {
        $this->adapter->setValue('key2', 1.0, ['label']);
        $this->adapter->setValue('key2', 2.0, ['label2']);

        $res = $this->adapter->getValues('key2');

        $this->assertCount(2, $res);
    }

    public function testIncrementFloatDefault(): void {
        $this->adapter->incValue('key', 1.0, 0.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(1.0, $res);
    }

    public function testIncrementCallableDefault(): void {
        $this->adapter->incValue('key', 1.0, function () {
            return 2.0;
        }, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(3.0, $res);
    }

    public function testIncrementValueAlreadyExists(): void {
        $this->adapter->setValue('key', 1.0, []);

        $this->adapter->incValue('key', 1.0, 0.0, []);

        $res = $this->adapter->getValue('key', []);

        $this->assertEquals(2.0, $res);
    }

    public function testGetPrefix(): void {
        $res = $this->adapter->getPrefix();

        $this->assertEquals('', $res);
    }
}
