<?php

namespace Schema31\PHPOnCouch\Service;

use Schema31\CouchDBClient\Service\CouchDB;
use PHPOnCouch\Couch;

/**
 * Description of PHPOnCouch
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class PHPOnCouch implements CouchDB {
    
    protected $couch;
     
    /**
     * @param string $method The HTTP method to use (GET,PUT,POST,...)
     * @param string $url The URL to fetch
     * @param array $parameters The query parameters to pass to the query
     * @param $data The request body
     * @param string $contentType The content type of the data
     */
    public function query(string $method, string $url, array $parameters = [], $data = null, string $contentType = null) {
        $raw = $this->couch->query($method, $url, $parameters, $data, $contentType);
        $response = Couch::parseRawResponse($raw);
        return $response;
    }

}
