<?php

namespace Schema31\PHPOnCouch\Service;

use Schema31\CouchDBClient\Service\CouchDBAdmin;
use Schema31\CouchDBClient\Exception\CouchDBException;

use PHPOnCouch\CouchAdmin;
use PHPOnCouch\CouchClient;

/**
 * Description of PHPOnCouchAdmin
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class PHPOnCouchAdmin extends PHPOnCouch implements CouchDBAdmin {
    private $admin;
      
    public function connect(string $url, string $db, array $options = []): void {        
        $this->couch = new CouchClient($url, $db, $options);
        $this->admin = new CouchAdmin($this->couch);
    }

    public function addAdminUser(string $user): void {
        try {
            $this->admin->addDatabaseAdminUser($user);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }
    }

    public function addMemberUser(string $user): void {
        try {
            $this->admin->addDatabaseMemberUser($user);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }
    }

    public function getAdminUsers(): array {
        try {
            $this->admin->getDatabaseAdminUsers();
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }
    }

    public function getMemberUsers(): array {
        try {
            $this->admin->getDatabaseMemberUsers();
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }
    }

    public function removeAdminUser(string $user): void {
        try {
            $this->admin->removeDatabaseAdminUser($user);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }
    }

    public function removeMemberUser(string $user): void {
        try {
            $this->admin->removeDatabaseMemberUser($user);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }                 
    }

}
