<?php

namespace Schema31\PHPOnCouch\Service;

use PHPOnCouch\CouchClient;
use Schema31\CouchDBClient\Domain\ViewRequest;

/**
 * Description of CustomCouchClient
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class CustomCouchClient extends CouchClient {
    
    public function getCustomView(ViewRequest $viewRequest) {
        if ($viewRequest->getSkip()) {
            $this->skip($viewRequest->getSkip());
        }

        if ($viewRequest->getLimit()) {
            $this->limit($viewRequest->getLimit());
        }

        if ($viewRequest->getDescending()) {
            $this->descending($viewRequest->getDescending());
        }   

        if ($viewRequest->getIncludeDocs()) {
            $this->include_docs($viewRequest->getIncludeDocs());
        }   

        $url = '/' . urlencode($this->dbname) . '/_design/' . urlencode($viewRequest->getDesign()) . '/_view/' . urlencode($viewRequest->getName());

        list($method, $viewQuery, $data) = $this->prepareViewQuery();
        
        if ($viewRequest->getStartkey()) {
            $viewQuery['startkey'] = $viewRequest->getStartkey();
        }  
        
        if ($viewRequest->getEndkey()) {
            $viewQuery['endkey'] = $viewRequest->getEndkey();
        }          

        return $this->queryAndValid($method, $url, [200], $viewQuery, $data);        
    }
}
