<?php

namespace Schema31\PHPOnCouch\Service;

use Schema31\CouchDBClient\Service\CouchDBClient;

use PHPOnCouch\CouchClient;
use PHPOnCouch\Exceptions\CouchNotFoundException;

use Schema31\CouchDBClient\Domain\ViewRequest;
use Schema31\CouchDBClient\Domain\ViewResponse;
use Schema31\CouchDBClient\Domain\MangoQuery;
use Schema31\CouchDBClient\Domain\MangoResponse;
use Schema31\CouchDBClient\Exception\CouchDBException;
use Schema31\CouchDBClient\Exception\NotFoundException;

/**
 * Description of PHPOnCouchClient
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class PHPOnCouchClient extends PHPOnCouch implements CouchDBClient {
      
    public function connect(string $url, string $db, array $options = []): void {        
        $this->couch = new CustomCouchClient($url, $db, $options);
    }
    
    // section database
    
    /**
     * @return array of string (the uuids)
     * @throws CouchDBException
     */
    public function getUuids(int $count = 1): array {
        try {
            return $this->couch->getUuids($count);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }
    }
    
    // section docs
    
    /**
     * @throws CouchDBException
     */
    public function getDoc(string $id) {
        try {
            return $this->couch->getDoc($id);
        } catch (CouchNotFoundException $e) {
            throw new NotFoundException($e->getMessage(), $e->getCode(), $e->getPrevious());
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }        
    }
   
    /**
     * @throws CouchDBException
     */
    public function storeDoc($doc): void {
        try {
            $response = $this->couch->storeDoc($doc);
            
            $doc->_id = $response->id;
            $doc->_rev = $response->rev;
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }        
    }
    
    /**
     * @return array of DocReference
     * @throws CouchDBException
     */
    public function storeDocs(array $docs): void {
        try {
            $responses = $this->couch->storeDocs($docs);
            
            foreach (array_values($docs) as $key => $doc) {
                $doc->_id = $responses[$key]->id;
                $doc->_rev = $responses[$key]->rev;
            }
           
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }          
    }
    
    /**
     * @throws CouchDBException
     */
    public function deleteDoc($doc): void {
        try {
            $this->couch->deleteDoc($doc);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }        
    }
    
    /**
     * @throws CouchDBException
     */
    public function deleteDocs(array $docs): void {
        try {
            $this->couch->deleteDocs($docs);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }         
    }
    
    // section views
    
    /**
     * @throws CouchDBException
     */
    public function getView(ViewRequest $viewRequest): ViewResponse {
        try {
            
            $response =  $this->couch->getCustomView($viewRequest);

            return new ViewResponse($response->total_rows, $response->offset, $response->rows);
        } catch (\Exception $e) {
            throw new CouchDBException($e->getMessage(), $e->getCode(), $e->getPrevious());
        }         
    }
    
    // section mango
    
    /**
     * @throws CouchDBException
     */
    public function find(MangoQuery $query): MangoResponse {
        return array();
    }

}
