<?php

namespace Schema31\P7MDecoder;

/**
 * @author Antonio Turdo <aturdo@schema31.it>
 */
interface P7MDecoderInterface {
    
    public function decodeContent(string $p7mContent, bool $signatureInfo = false, bool $nestedSignatures = false);
    
    public function decodeFile(string $p7mFilepath, bool $signatureInfo = false, bool $nestedSignatures = false);
    
    public function verifyContentSignature(string $p7mContent, bool $signatureInfo = false, array $signerFiscalCodes = []);
    
    public function verifyFileSignature(string $p7mFilepath, bool $signatureInfo = false, array $signerFiscalCodes = []);
}
