<?php

namespace Schema31\JobManager\Domain;

/**
 * Description of Job
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
abstract class Job {
    
    protected $topic;
    protected $submitter;
    protected $status;
    protected $details;
    protected $history;
    protected $creationDate;
    protected $updateDate;
    
    public function __construct(string $topic, string $submitter, string $status, array $details) {
        $this->topic = $topic;
        $this->submitter = $submitter;
        $this->status = $status;
        $this->details = $details;
        $this->history = array();
        $this->creationDate = new \DateTime();
        $this->updateDate = $this->creationDate;
    }
    
    public function addHistory($history) {
        $this->history[] = $history;
    }
    
    public function getTopic() {
        return $this->topic;
    }
    
    public function getSubmitter() {
        return $this->submitter;
    }

    public function getStatus() {
        return $this->status;
    }

    public function getDetails() {
        return $this->details;
    }

    public function getCreationDate() {
        return $this->creationDate;
    }

    public function getUpdateDate() {
        return $this->updateDate;
    }

}
