<?php

namespace Schema31\JobManager\Domain;

/**
 * Description of Job
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Job {
    
    private $topic;
    private $status;
    private $details;
    private $history;
    private $creationDate;
    private $updateDate;
    
    public function __construct(string $topic, string $status, array $details) {
        $this->topic = $topic;
        $this->status = $status;
        $this->details = $details;
        $this->history = array();
        $this->creationDate = new \DateTime();
        $this->updateDate = $this->creationDate;
    }
    
    public function addHistory($history) {
        $this->history[] = $history;
    }
    
    public function getTopic() {
        return $this->topic;
    }

    public function getStatus() {
        return $this->status;
    }

    public function getDetails() {
        return $this->details;
    }

    public function getCreationDate() {
        return $this->creationDate;
    }

    public function getUpdateDate() {
        return $this->updateDate;
    }

}
