<?php

namespace Schema31\JobManager\Domain;

/**
 * Description of Job
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class Job {
    
    private $topic;
    private $status;
    private $details;
    private $creationDate;
    private $updateDate;
    
    function __construct(string $topic, string $status, array $details) {
        $this->topic = $topic;
        $this->status = $status;
        $this->details = $details;
        $this->creationDate = new \DateTime();
        $this->updateDate = $this->creationDate;
    }
    
    public function getTopic() {
        return $this->topic;
    }

    public function getStatus() {
        return $this->status;
    }

    public function getDetails() {
        return $this->details;
    }

    public function getCreationDate() {
        return $this->creationDate;
    }

    public function getUpdateDate() {
        return $this->updateDate;
    }

}
