<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotNull;

/**
 * Descrizione di IndirizzoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class IndirizzoType extends LuogoType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);
        
        $builder->add('via', null, ['label' => 'Indirizzo', 'constraints' => [new NotNull()]]);
        $builder->add('numeroCivico', null, ['label' => 'Numero civico', 'constraints' => [new NotNull()]]);
        $builder->add('cap', null, ['label' => 'CAP', 'constraints' => [new NotNull()]]);  
    } 
    
    public function buildView(FormView $view, FormInterface $form, array $options) {   
        $view->vars['cessati'] = $options['cessati'];
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'cessati' => false
        ));
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
