<?php

namespace Schema31\GeoBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Schema31\GeoBundle\Entity\GeoStato;
use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of CodiceCatastoRepository
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class CodiceCatastoRepository extends EntityRepository {
    
    public function getStatoByCodiceCatasto(string $codiceCatasto) {
        $codiceCatastoObject = $this->findOneBy(['codiceCatasto' => $codiceCatasto]);
        
        if (is_null($codiceCatastoObject)) {
            return null;
        }
        
        return $this->getEntityManager()->getRepository(GeoStato::class)->findOneBy(['codiceISTAT' => $codiceCatastoObject->getCodiceISTAT()]);
    }
    
    public function getComuneByCodiceCatasto(string $codiceCatasto) {
        $codiceCatastoObject = $this->findOneBy(['codiceCatasto' => $codiceCatasto]);
        
        if (is_null($codiceCatastoObject)) {
            return null;
        }
        
        return $this->getEntityManager()->getRepository(GeoComune::class)->findOneBy(['codiceISTAT' => $codiceCatastoObject->getCodiceISTAT()]);
    }    
}
