<?php

namespace Schema31\GeoBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="geo")
 * @ORM\InheritanceType("SINGLE_TABLE")
 * @ORM\DiscriminatorColumn(name="discr", type="string")
 * @ORM\DiscriminatorMap({"stato" = "GeoStato", "regione" = "GeoRegione", "provincia" = "GeoProvincia", "comune" = "GeoComune"})
 */
abstract class Geo {

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @ORM\Column(type="string", length=255)
     */
    protected $denominazione;
     
    /**
     * @ORM\Column(type="boolean")
     */
    protected $cessato;    

    /**
     * @ORM\Column(type="date")
     */
    protected $dataIstituzione;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    protected $dataDestituzione;
    
    /**
     * @ORM\ManyToOne(targetEntity="Geo", inversedBy="suddivisioniInferiori")
     * @ORM\JoinColumn(nullable=true)
     */
    protected $suddivisioneSuperiore;   
    
    /**
     * @ORM\OneToMany(targetEntity="Geo", mappedBy="suddivisioneSuperiore")
     */
    protected $suddivisioniInferiori;  
    
    /**
     * @ORM\Column(type="string", length=16, nullable=true)
     */
    protected $codiceISTAT;    
    
    public function getId() {
        return $this->id;
    }

    public function getDenominazione() {
        return $this->denominazione;
    }

    public function getDataIstituzione() {
        return $this->dataIstituzione;
    }

    public function getDataDestituzione() {
        return $this->dataDestituzione;
    }
    
    public function getCessato() {
        return $this->cessato;
    }

    public function getSuddivisioneSuperiore() {
        return $this->suddivisioneSuperiore;
    }

    public function getSuddivisioniInferiori() {
        return $this->suddivisioniInferiori;
    }

    public function getCodiceISTAT() {
        return $this->codiceISTAT;
    }
 
	public function __toString() {
		return $this->getDenominazione();
	}    
}
