<?php

namespace Schema31\GeoBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Schema31\GeoBundle\Repository\CodiceCatastoRepository;

/**
 * @ORM\Entity(repositoryClass=CodiceCatastoRepository::class)
 * @ORM\Table(name="codici_catasto")
 */
class CodiceCatasto {

    /**
     * @var string $codiceCatasto
     * 
     * @ORM\Id
     * @ORM\Column(type="string", length=4, nullable=false)
     */
    protected $codiceCatasto;
    
    /**
     * @var string $codiceISTAT
     * 
     * @ORM\Column(type="string", length=16, nullable=false)
     */
    protected $codiceISTAT;
    
    /**
     * @ORM\Column(type="date", nullable=true)
     */
    protected $dataIstituzione;

    /**
     * @ORM\Column(type="date", nullable=true)
     */
    protected $dataDestituzione;    
    
    public function getCodiceCatasto(): string {
        return $this->codiceCatasto;
    }

    public function getCodiceISTAT(): string {
        return $this->codiceISTAT;
    }
    
    public function getDataIstituzione() {
        return $this->dataIstituzione;
    }

    public function getDataDestituzione() {
        return $this->dataDestituzione;
    }

}
