<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\OrderBy;

use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Descrizione di IndirizzoRegioneItaliaType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class IndirizzoRegioneItaliaType extends AbstractType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $optionsProvincia = [];
        
        $optionsProvincia['query_builder'] = function (EntityRepository $er) use ($options){
                $orderBy = new OrderBy();
                $orderBy->add('g.denominazione', 'ASC');

                $qb = $er->createQueryBuilder('g')
                ->where('g.regione = '.$options['regione']->getId());

                if (!$options['cessati']) {
                    $qb->andWhere('g.cessato = 0');
                }

                return $qb->orderBy($orderBy);
            };            
        
        $builder->add('provincia', GeoProvinciaType::class, $optionsProvincia);
        
        $builder->addEventListener(
            FormEvents::PRE_SET_DATA,
            function (FormEvent $event) use ($options){
                $provincia = $event->getData()->getProvincia();
                
                $this->addComuneForm($event->getForm(), is_null($provincia) ? null : $provincia->getId(), $options);
            }                
        );
        
        $builder->addEventListener(
            FormEvents::PRE_SUBMIT, 
            function (FormEvent $event) use ($options){
                $data = $event->getData();

               $this->addComuneForm($event->getForm(), isset($data['provincia']) ? (int) $data['provincia'] : null, $options);
            }
        );           
    }
    
    private function addComuneForm(FormInterface $form, ?int $provinciaId, array $options) {
        $hasComune = !is_null($provinciaId);

        $optionsComune = ['class' => GeoComune::class, 'placeholder' => '', 'required' => true];
        if (!$hasComune) {
            $optionsComune['choices'] = [];
            $optionsComune['disabled'] = true;
        } else {
            $optionsComune['disabled'] = false;

            $optionsComune['query_builder'] = function (EntityRepository $er) use ($provinciaId, $options){
                $orderBy = new OrderBy();
                $orderBy->add('g.capoluogo', 'DESC');
                $orderBy->add('g.denominazione', 'ASC');

                $qb = $er->createQueryBuilder('g')
                ->where('g.suddivisioneSuperiore = '.$provinciaId);

                if (!$options['cessati']) {
                    $qb->andWhere('g.cessato = 0');
                }

                return $qb->orderBy($orderBy);
            };
        }

        $form->add('comune', EntityType::class, $optionsComune);  

        $this->completeForm($form);        
    }
    
    private function completeForm(FormInterface $form) {
        $form->add('via', null, ['label' => 'Indirizzo']);
        $form->add('numeroCivico', null, ['label' => 'Numero civico']);
        $form->add('cap', null, ['label' => 'CAP']);        
    }    
    
    public function buildView(FormView $view, FormInterface $form, array $options) {   
        $view->vars['cessati'] = $options['cessati'];
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'cessati' => false
        ));
        
        $resolver->setRequired('regione');
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
