<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;

use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\Query\Expr\OrderBy;

use Schema31\GeoBundle\Type\GeoStatoType;

use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Descrizione di IndirizzoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class IndirizzoType extends LuogoType {

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        parent::buildForm($builder, $options);
        
        $builder->add('via', null, ['label' => 'Indirizzo']);
        $builder->add('numeroCivico', null, ['label' => 'Numero civico']);
        $builder->add('cap', null, ['label' => 'CAP']);  
    } 
    
    public function buildView(FormView $view, FormInterface $form, array $options) {   
        $view->vars['cessati'] = $options['cessati'];
    }
    
    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'cessati' => false
        ));
    } 
    
    public function getParent() {
        return \Symfony\Component\Form\Extension\Core\Type\FormType::class;
    }

}
