<?php

namespace Schema31\GeoBundle\Type;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\OptionsResolver\Options;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;

use Doctrine\ORM\EntityRepository;

use Schema31\GeoBundle\Entity\GeoProvincia;

/**
 * Descrizione di GeoStatoType
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class GeoProvinciaType extends AbstractType {

    public function configureOptions(OptionsResolver $resolver) 
    {
        $resolver->setDefaults(array(
            'class' => GeoProvincia::class,
            'placeholder' => '',
            'cessati' => false
        ));
                
        $resolver->setDefault('query_builder', function (Options $options) {
            return function (EntityRepository $er) use ($options) {
                $qb = $er->createQueryBuilder('g');
                
                if (!$options['cessati']) {
                    $qb->where('g.cessato = 0');
                }
                
                return $qb->orderBy('g.denominazione', 'ASC');
                };
        });                
    }
    
    public function getParent()
    {
        return EntityType::class;
    }    

}
