<?php

namespace Schema31\GeoBundle\Model;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Context\ExecutionContextInterface;

use Schema31\GeoBundle\Entity\GeoStato;
use Schema31\GeoBundle\Entity\GeoRegione;
use Schema31\GeoBundle\Entity\GeoProvincia;
use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of LuogoTrait
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
trait LuogoTrait {

    /**
     * @var GeoStato $stato
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoStato")
     * @ORM\JoinColumn(nullable=false)
     * 
     * @Assert\NotNull
     */       
    private $stato;

    /**
     * @var ?GeoRegione $regione
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoRegione")
     * @ORM\JoinColumn(nullable=true)
     */    
    private $regione;
    
    /**
     * @var ?GeoProvincia $provincia
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoProvincia")
     * @ORM\JoinColumn(nullable=true)
     */ 
    private $provincia;
    
    /**
     * @var ?GeoComune $comune
     *
     * @ORM\ManyToOne(targetEntity="Schema31\GeoBundle\Entity\GeoComune")
     * @ORM\JoinColumn(nullable=true)
     */    
    private $comune;
    
    /**
     * @var string
     *
     * @ORM\Column(type="string", nullable=true)
     */    
    private $localitaEstera;    
    
    public function getStato(): ?GeoStato  {
        return $this->stato;
    }

    public function getRegione(): ?GeoRegione {
        return $this->regione;
    }
    
    public function getProvincia(): ?GeoProvincia {
        return $this->provincia;
    }

    public function getComune(): ?GeoComune {
        return $this->comune;
    }
    
    public function setStato(GeoStato $stato) {
        $this->stato = $stato;
    }

    public function setRegione(?GeoRegione $regione) {
        $this->regione = $regione;
    }
    
    public function setProvincia(?GeoProvincia $provincia) {
        $this->provincia = $provincia;
    }

    public function setComune(?GeoComune $comune) {
        $this->comune = $comune;
    }
      
    public function getLocalitaEstera(): ?string{
        return $this->localitaEstera;
    }

    public function setLocalitaEstera(?string $localitaEstera) {
        $this->localitaEstera = $localitaEstera;
    }
    
    public function getDescrizioneLuogo(): string {
        $descrizione = "";
        
        if (!is_null($this->comune)) {
            $descrizione = $this->comune->getDenominazione(). " (".$this->getProvincia()->getSiglaAutomobilistica().")";
        } else {
            $descrizione = $this->getLocalitaEstera();
        }
        
        $descrizione .=  ", ".$this->getStato()->getDenominazione();
        
        return $descrizione;
    }
    
    /**
     * @Assert\Callback
     */
    public function validate(ExecutionContextInterface $context, $payload)
    {
        $luogo = $context->getValue();
        
        if (is_null($luogo->getStato())) 
        {
            return;
        }
        
        if ($luogo->getStato()->getId() == \Schema31\GeoBundle\Schema31GeoBundle::ITALIA_ID){
            if (is_null($luogo->getComune())) {
                $context->buildViolation('Se hai selezionato Italia, il comune è obbligatorio')
                    ->atPath('comune')
                    ->addViolation();                
            }
        } else {
            if (is_null($luogo->getLocalitaEstera())) {
                $context->buildViolation('Se hai selezionato uno stato diverso da Italia, la località estera è obbligatoria')
                    ->atPath('localitaEstera')
                    ->addViolation();                
            }            
        }
    }    
}
