<?php

namespace Schema31\GeoBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

use Schema31\GeoBundle\Entity\GeoComune;

/**
 * Description of ComuneController
 *
 * @author Antonio Turdo <aturdo@schema31.it>
 */
class ComuneController extends Controller {
    
    /**
     * @Route("/byProvincia/{provinciaId}/{cessati}", defaults={"cessati" = "0"})
     */
    public function comuniByProvinciaAction($provinciaId, $cessati = "0")
    {
        $em = $this->get('doctrine')->getManager();
        
        $filters = ['suddivisioneSuperiore' => $provinciaId];
        
        if ($cessati == "0") {
            $filters['cessato'] = 0;
        }
        
        $comuni = $em->getRepository(GeoComune::class)->findBy($filters, ['capoluogo' => 'DESC', 'denominazione' => 'ASC']);
        
        $result = new \stdClass();
        $result->count = count($comuni);
        $result->items = array_map(function($comune) { 
            $resultComune = new \stdClass(); 
            $resultComune->id = $comune->getId();   
            $resultComune->denominazione = $comune->getDenominazione();
            
            return $resultComune;
        }, $comuni);

        return new JsonResponse($result);
    }
    
    /**
     * @Route("/bySearch/{cessati}", defaults={"cessati" = "0"})
     */
    public function comuniBySearchAction(Request $request,  $cessati = "0")
    {
        $em = $this->get('doctrine')->getManager();
        
        $filters = [];
        if ($cessati == "0") {
            $filters['cessato'] = 0;
        }
        
        if (!$request->query->has("search")) {
            return $this->createJsonResponse([]);
        }
        
        $qb = $em->getRepository(GeoComune::class)
                ->createQueryBuilder('g')
                ->where("g.denominazione LIKE '".$request->query->get('search')."%'");
        
        if ($cessati == "0") {
            $qb->andWhere("g.cessato = 0");
        }
       
        $qb->orderBy("g.denominazione", "ASC");
        
        $comuni =  $qb->getQuery()->getResult();
        
        return $this->createJsonResponse($comuni);
    }   
    
    private function createJsonResponse($comuni) {
        $result = new \stdClass();
        $result->count = count($comuni);
        $result->items = array_map(function($comune) { 
            $resultComune = new \stdClass(); 
            $resultComune->id = $comune->getId();   
            $resultComune->denominazione = $comune->getDenominazione();
            
            return $resultComune;
        }, $comuni);

        return new JsonResponse($result);        
    }
}
